/* -*-C-*-
 ##############################################################################
 #
 # File:        trice/src/selftest.c
 # RCS:         "@(#)$Revision: 1.25 $ $Date: 94/03/17 11:28:51 $"
 # Description: User routine for doing self test of E1430 module
 # Author:      Doug Passey
 # Created:     
 # Language:    C
 # Package:     E1430
 # Status:      "@(#)$State: Exp $"
 #
 # (C) Copyright 1992, Hewlett-Packard Company, all rights reserved.
 #
 ##############################################################################
 #
 # Please add additional comments here
 #
 # Revisions:
 #
 ##############################################################################
*/

#    include <stdio.h>
#    include <math.h>

#include "trice.h"
#include "err1430.h"

extern const char rev[];

/*****************************************************************************
 *
 * Return revision
 *
 *****************************************************************************/
const char *e1430_get_software_rev(void)
{
  return (rev);
}

#ifdef _WINDLL
/*****************************************************************************
 *
 * Similar to above, but fills an array with the revision string.
 * This may easier to call in mixed language environments.
 * The array is assumed to have 255 elements.  Returns the number
 * of characters written.
 *
 *****************************************************************************/
SHORTSIZ16 e1430_fill_software_rev( SHORTSIZ16 *stringa )
{
  SHORTSIZ16 len = 0; 
  const char * p; 

  p = rev;
  while ((*p != 0) && (len<255)) {
     *(stringa++) = *(p++);
     len++;
  }
  return (len);
}
#endif /*_WINDLL*/


/*****************************************************************************
 *
 * Run all diagnostic routines
 *
 ****************************************************************************/
SHORTSIZ16 e1430_diagnostics(SHORTSIZ16 la, SHORTSIZ16 flag) 
{
  SHORTSIZ16 error = 0, index;
  aModuleImage image;
  SHORTSIZ16 saved_printFlag = e1430_printFlag;


  /* reset the card into a known state */
  e1430_hard_reset(la);
  i1430_reset_E1430(la);

  /* save (the reset) state for later restore.  get_index()  may fail  
   * if the module is not part of a group, so disable error print.
   */
  e1430_printFlag = 0;    
  i1430_get_index_from_la(la, &index);
  e1430_printFlag = saved_printFlag;    

  image = e1430_modStates[index];	/* save current state */

  if(flag & REG_ACCESS_TEST_FLAG) {
    if(e1430_debug) (void)printf("Starting e1430_test_logical_address ...\n");
    error = e1430_test_logical_address(la);
    if(error) goto bad;
  }

  if(e1430_debug) 
    (void)printf("Starting e1430_test_register_access ...\n");
    error = e1430_test_register_access(la);
    if(error) goto bad;

  if(flag & MEM_TEST_FLAG) {
    if(e1430_debug) (void)printf("Starting e1430_test_fifo_memory ...\n");
    error = e1430_test_fifo_memory(la);
    if(error) goto bad;
  }
  if(e1430_device_clear_flag) return(0);

  if(e1430_debug) (void)printf("Starting e1430_test_timing_setup ...\n");
  error = e1430_test_timing_setup(la);
  if(error) goto bad;
  if(e1430_device_clear_flag) return(0);

  if(e1430_debug) (void)printf("Starting e1430_test_meas_control ...\n");
  error = e1430_test_meas_control(la);
  if(error) goto bad;
  if(e1430_device_clear_flag) return(0);

  if(e1430_debug) (void)printf("Starting e1430_test_data_collection ...\n");
  error = e1430_test_data_collection(la);
  if(error) goto bad;
  if(e1430_device_clear_flag) return(0);

  if(e1430_debug) (void)printf("Starting e1430_test_interrupts ...\n");
  error = e1430_test_interrupts(la);
  if(error) goto bad;
  if(e1430_device_clear_flag) return(0);

  if(e1430_debug) (void)printf("Starting e1430_test_trigger ...\n");
  error = e1430_test_trigger(la);

bad:
  e1430_hard_reset(la);

  i1430_reset_E1430(la);

  i1430_restore_state_la(la, &image);

  return(error);
}
